<?php
// Configuración de la base de datos
$host = 'eth.v2net.cl';
$usuario = 'aqua1_agenda1';
$password = 'aquaagenda2121';
$base_datos = 'aqua1_agenda';

// Habilitar visualización de errores
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Configurar cabeceras para CORS
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

// Intentar conectar a la base de datos
try {
    $conexion = new mysqli($host, $usuario, $password, $base_datos);
    
    // Verificar si hay errores de conexión
    if ($conexion->connect_error) {
        echo json_encode([
            'success' => false,
            'message' => 'Error de conexión a la base de datos',
            'error' => $conexion->connect_error,
            'error_no' => $conexion->connect_errno,
            'config' => [
                'host' => $host,
                'usuario' => $usuario,
                'base_datos' => $base_datos
            ]
        ]);
        exit;
    }
    
    // Probar una consulta simple
    $resultado = $conexion->query("SELECT 1 as test");
    $fila = $resultado->fetch_assoc();
    
    echo json_encode([
        'success' => true,
        'message' => 'Conexión exitosa a la base de datos',
        'test_result' => $fila['test'],
        'config' => [
            'host' => $host,
            'usuario' => $usuario,
            'base_datos' => $base_datos
        ],
        'server_info' => $conexion->server_info
    ]);
    
    // Cerrar la conexión
    $conexion->close();
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error al conectar a la base de datos',
        'error' => $e->getMessage(),
        'config' => [
            'host' => $host,
            'usuario' => $usuario,
            'base_datos' => $base_datos
        ]
    ]);
}
?>
