<?php
require_once 'config.php';

// Procesar solicitud de inicio de sesión
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Obtener datos del cuerpo de la solicitud
        $datos = json_decode(file_get_contents('php://input'), true);
        
        if (!$datos || !isset($datos['email']) || !isset($datos['password'])) {
            responder(['error' => 'Datos de inicio de sesión inválidos'], 400);
        }
        
        $email = $conexion->real_escape_string($datos['email']);
        $password = $datos['password'];
        
        // Para este ejemplo, usamos credenciales fijas
        // En una aplicación real, deberías verificar contra la base de datos
        if ($email === 'usuario@ejemplo.com' && $password === 'password') {
            responder([
                'success' => true,
                'usuario' => [
                    'id' => 1,
                    'nombre' => 'Usuario Demo',
                    'email' => $email,
                    'rol' => 'admin'
                ],
                'token' => 'token_demo_' . time() // En una app real, generarías un JWT
            ]);
        } else {
            responder(['error' => 'Credenciales incorrectas'], 401);
        }
    } catch (Exception $e) {
        responder(['error' => 'Error en el servidor: ' . $e->getMessage()], 500);
    }
}

// Verificar si el token es válido
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['verificar'])) {
    try {
        // En una app real, verificarías el token JWT
        // Para este ejemplo, simplemente devolvemos éxito
        responder([
            'success' => true,
            'mensaje' => 'Token válido'
        ]);
    } catch (Exception $e) {
        responder(['error' => 'Error en el servidor: ' . $e->getMessage()], 500);
    }
}

// Si llegamos aquí, el método no está soportado
responder(['error' => 'Método no soportado'], 405);
?>
