<?php
require_once 'config.php';

// Obtener todas las interacciones
if ($_SERVER['REQUEST_METHOD'] === 'GET' && !isset($_GET['id']) && !isset($_GET['cliente_id'])) {
    try {
        $query = "SELECT i.*, c.nombre as nombre_cliente 
                  FROM interacciones i 
                  JOIN clientes c ON i.cliente_id = c.id 
                  ORDER BY i.fecha DESC";
        $resultado = $conexion->query($query);
        
        if (!$resultado) {
            responder(['error' => 'Error al obtener las interacciones: ' . $conexion->error], 500);
        }
        
        $interacciones = [];
        while ($fila = $resultado->fetch_assoc()) {
            $interacciones[] = $fila;
        }
        
        responder($interacciones);
    } catch (Exception $e) {
        responder(['error' => 'Error al obtener las interacciones: ' . $e->getMessage()], 500);
    }
}

// Obtener interacciones de un cliente específico
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['cliente_id'])) {
    try {
        $cliente_id = $conexion->real_escape_string($_GET['cliente_id']);
        $query = "SELECT * FROM interacciones WHERE cliente_id = '$cliente_id' ORDER BY fecha DESC";
        $resultado = $conexion->query($query);
        
        if (!$resultado) {
            responder(['error' => 'Error al obtener las interacciones del cliente: ' . $conexion->error], 500);
        }
        
        $interacciones = [];
        while ($fila = $resultado->fetch_assoc()) {
            $interacciones[] = $fila;
        }
        
        responder($interacciones);
    } catch (Exception $e) {
        responder(['error' => 'Error al obtener las interacciones del cliente: ' . $e->getMessage()], 500);
    }
}

// Crear una nueva interacción
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Obtener datos del cuerpo de la solicitud
        $datos = json_decode(file_get_contents('php://input'), true);
        
        if (!$datos) {
            responder(['error' => 'Datos inválidos'], 400);
        }
        
        // Validar datos requeridos
        if (empty($datos['cliente_id']) || empty($datos['tipo']) || empty($datos['descripcion'])) {
            responder(['error' => 'El cliente, tipo y descripción son obligatorios'], 400);
        }
        
        // Preparar consulta
        $cliente_id = $conexion->real_escape_string($datos['cliente_id']);
        $tipo = $conexion->real_escape_string($datos['tipo']);
        $descripcion = $conexion->real_escape_string($datos['descripcion']);
        $fecha = isset($datos['fecha']) ? $conexion->real_escape_string($datos['fecha']) : date('Y-m-d H:i:s');
        
        $query = "INSERT INTO interacciones (cliente_id, tipo, descripcion, fecha) 
                  VALUES ('$cliente_id', '$tipo', '$descripcion', '$fecha')";
        
        if (!$conexion->query($query)) {
            responder(['error' => 'Error al crear la interacción: ' . $conexion->error], 500);
        }
        
        responder([
            'id' => $conexion->insert_id,
            'mensaje' => 'Interacción registrada correctamente'
        ], 201);
    } catch (Exception $e) {
        responder(['error' => 'Error al crear la interacción: ' . $e->getMessage()], 500);
    }
}

// Eliminar una interacción
if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
    try {
        // Obtener datos del cuerpo de la solicitud
        $datos = json_decode(file_get_contents('php://input'), true);
        
        if (!$datos || !isset($datos['id'])) {
            responder(['error' => 'ID no proporcionado'], 400);
        }
        
        $id = $conexion->real_escape_string($datos['id']);
        
        // Primero verificar si la interacción existe
        $query = "SELECT id FROM interacciones WHERE id = '$id'";
        $resultado = $conexion->query($query);
        
        if ($resultado->num_rows === 0) {
            responder(['error' => 'Interacción no encontrada'], 404);
        }
        
        // Eliminar la interacción
        $query = "DELETE FROM interacciones WHERE id = '$id'";
        
        if (!$conexion->query($query)) {
            responder(['error' => 'Error al eliminar la interacción: ' . $conexion->error], 500);
        }
        
        responder(['mensaje' => 'Interacción eliminada correctamente']);
    } catch (Exception $e) {
        responder(['error' => 'Error al eliminar la interacción: ' . $e->getMessage()], 500);
    }
}

// Si llegamos aquí, el método no está soportado
responder(['error' => 'Método no soportado'], 405);
?>
