<?php
// Configuración de la base de datos
$host = 'eth.v2net.cl';
$usuario = 'aqua1_agenda1';
$password = 'aquaagenda2121';
$base_datos = 'aqua1_agenda';

// Crear conexión
$conexion = new mysqli($host, $usuario, $password, $base_datos);

// Verificar conexión
if ($conexion->connect_error) {
    die("Error de conexión: " . $conexion->connect_error);
}

// Configurar codificación de caracteres
$conexion->set_charset("utf8");

// Función para manejar errores y devolver respuestas JSON
function responder($datos, $codigo = 200) {
    http_response_code($codigo);
    header('Content-Type: application/json');
    
    // Asegurarse de que la respuesta sea un array si se espera una lista
    if (is_array($datos) && !isset($datos['error']) && !isset($datos['mensaje']) && !isset($datos['id'])) {
        // Si es un array asociativo con claves no numéricas, envolverlo en un array
        $esArrayAsociativo = false;
        foreach ($datos as $key => $value) {
            if (!is_numeric($key)) {
                $esArrayAsociativo = true;
                break;
            }
        }
        
        if ($esArrayAsociativo && count($datos) > 0) {
            $datos = [$datos];
        }
    }
    
    echo json_encode($datos);
    exit;
}

// Obtener el origen de la solicitud
$http_origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';

// Lista de orígenes permitidos
$allowed_origins = [
    'http://localhost:5173',           // Vite dev server
    'http://localhost:5174',           // Alternativa de Vite
    'http://localhost:3000',           // Por si usas otro puerto
    'https://agen.aqualider.cl',       // Producción
    'http://agen.aqualider.cl'         // Producción sin HTTPS
];

// Verificar si el origen está permitido
if (in_array($http_origin, $allowed_origins)) {
    header("Access-Control-Allow-Origin: $http_origin");
} else {
    header("Access-Control-Allow-Origin: *");
}

// Resto de cabeceras CORS
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Max-Age: 3600"); // Cache preflight por 1 hora

// Manejar solicitudes OPTIONS (preflight)
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit;
}
?>
