<?php
require_once 'config.php';

// Obtener todos los clientes
if ($_SERVER['REQUEST_METHOD'] === 'GET' && !isset($_GET['id'])) {
    try {
        $query = "SELECT * FROM clientes ORDER BY nombre";
        $resultado = $conexion->query($query);
        
        if (!$resultado) {
            responder(['error' => 'Error al obtener los clientes: ' . $conexion->error], 500);
        }
        
        $clientes = [];
        while ($fila = $resultado->fetch_assoc()) {
            $clientes[] = $fila;
        }
        
        responder($clientes);
    } catch (Exception $e) {
        responder(['error' => 'Error al obtener los clientes: ' . $e->getMessage()], 500);
    }
}

// Obtener un cliente específico
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['id'])) {
    try {
        $id = $conexion->real_escape_string($_GET['id']);
        $query = "SELECT * FROM clientes WHERE id = '$id'";
        $resultado = $conexion->query($query);
        
        if (!$resultado) {
            responder(['error' => 'Error al obtener el cliente: ' . $conexion->error], 500);
        }
        
        $cliente = $resultado->fetch_assoc();
        
        if (!$cliente) {
            responder(['error' => 'Cliente no encontrado'], 404);
        }
        
        responder($cliente);
    } catch (Exception $e) {
        responder(['error' => 'Error al obtener el cliente: ' . $e->getMessage()], 500);
    }
}

// Crear un nuevo cliente
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Obtener datos del cuerpo de la solicitud
        $datos = json_decode(file_get_contents('php://input'), true);
        
        if (!$datos) {
            responder(['error' => 'Datos inválidos'], 400);
        }
        
        // Validar datos requeridos
        if (empty($datos['nombre']) || empty($datos['email'])) {
            responder(['error' => 'El nombre y el email son obligatorios'], 400);
        }
        
        // Preparar consulta
        $nombre = $conexion->real_escape_string($datos['nombre']);
        $apellido = $conexion->real_escape_string($datos['apellido'] ?? '');
        $email = $conexion->real_escape_string($datos['email']);
        $telefono = $conexion->real_escape_string($datos['telefono'] ?? '');
        $empresa = $conexion->real_escape_string($datos['empresa'] ?? '');
        $direccion = $conexion->real_escape_string($datos['direccion'] ?? '');
        $notas = $conexion->real_escape_string($datos['notas'] ?? '');
        
        $query = "INSERT INTO clientes (nombre, apellido, email, telefono, empresa, direccion, notas, fecha_registro) 
                  VALUES ('$nombre', '$apellido', '$email', '$telefono', '$empresa', '$direccion', '$notas', NOW())";
        
        if (!$conexion->query($query)) {
            responder(['error' => 'Error al crear el cliente: ' . $conexion->error], 500);
        }
        
        responder([
            'id' => $conexion->insert_id,
            'mensaje' => 'Cliente creado correctamente'
        ], 201);
    } catch (Exception $e) {
        responder(['error' => 'Error al crear el cliente: ' . $e->getMessage()], 500);
    }
}

// Actualizar un cliente
if ($_SERVER['REQUEST_METHOD'] === 'PUT') {
    try {
        // Obtener datos del cuerpo de la solicitud
        $datos = json_decode(file_get_contents('php://input'), true);
        
        if (!$datos || !isset($datos['id'])) {
            responder(['error' => 'Datos inválidos o ID no proporcionado'], 400);
        }
        
        // Validar datos requeridos
        if (empty($datos['nombre']) || empty($datos['email'])) {
            responder(['error' => 'El nombre y el email son obligatorios'], 400);
        }
        
        // Preparar consulta
        $id = $conexion->real_escape_string($datos['id']);
        $nombre = $conexion->real_escape_string($datos['nombre']);
        $apellido = $conexion->real_escape_string($datos['apellido'] ?? '');
        $email = $conexion->real_escape_string($datos['email']);
        $telefono = $conexion->real_escape_string($datos['telefono'] ?? '');
        $empresa = $conexion->real_escape_string($datos['empresa'] ?? '');
        $direccion = $conexion->real_escape_string($datos['direccion'] ?? '');
        $notas = $conexion->real_escape_string($datos['notas'] ?? '');
        
        $query = "UPDATE clientes 
                  SET nombre = '$nombre', 
                      apellido = '$apellido', 
                      email = '$email', 
                      telefono = '$telefono', 
                      empresa = '$empresa', 
                      direccion = '$direccion', 
                      notas = '$notas', 
                      fecha_actualizacion = NOW() 
                  WHERE id = '$id'";
        
        if (!$conexion->query($query)) {
            responder(['error' => 'Error al actualizar el cliente: ' . $conexion->error], 500);
        }
        
        if ($conexion->affected_rows === 0) {
            responder(['error' => 'No se encontró el cliente o no se realizaron cambios'], 404);
        }
        
        responder(['mensaje' => 'Cliente actualizado correctamente']);
    } catch (Exception $e) {
        responder(['error' => 'Error al actualizar el cliente: ' . $e->getMessage()], 500);
    }
}

// Eliminar un cliente
if ($_SERVER['REQUEST_METHOD'] === 'DELETE') {
    try {
        // Obtener datos del cuerpo de la solicitud
        $datos = json_decode(file_get_contents('php://input'), true);
        
        if (!$datos || !isset($datos['id'])) {
            responder(['error' => 'ID no proporcionado'], 400);
        }
        
        $id = $conexion->real_escape_string($datos['id']);
        
        // Primero verificar si el cliente existe
        $query = "SELECT id FROM clientes WHERE id = '$id'";
        $resultado = $conexion->query($query);
        
        if ($resultado->num_rows === 0) {
            responder(['error' => 'Cliente no encontrado'], 404);
        }
        
        // Eliminar el cliente
        $query = "DELETE FROM clientes WHERE id = '$id'";
        
        if (!$conexion->query($query)) {
            responder(['error' => 'Error al eliminar el cliente: ' . $conexion->error], 500);
        }
        
        responder(['mensaje' => 'Cliente eliminado correctamente']);
    } catch (Exception $e) {
        responder(['error' => 'Error al eliminar el cliente: ' . $e->getMessage()], 500);
    }
}

// Si llegamos aquí, el método no está soportado
responder(['error' => 'Método no soportado'], 405);
?>
